//##############################################################
//
// Slider.cpp : implementation file
//
//##############################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "SpeedDomeDoc.h"
#include "SpeedDomeView.h"
#include "misc.h"
#include "MainFrm.h"
#include "stdafx.h"
#include "Comm.h"
#include "Slider.h"
#include "GlobalVar.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//################################################################
// DrawSliderChannel()
//#################################################################

void S_DrawSliderChannel(CWnd* pWnd ,CBitmap* SliderBmap)
{   
CClientDC	dc( pWnd );			// dc is radar-frame in dialog box
CRect		rect;				// radar-frame size
CDC			m_dcMem;			// Compatible memory DC for Radar show   

//-- Get frame coordinate -- Zero based coordinate ----
pWnd->GetClientRect(&rect);	
VERIFY(m_dcMem.CreateCompatibleDC(&dc));				//---- Create memory DC using the LED-frame

m_dcMem.SelectObject(SliderBmap);						//---- load LED-frame's bitmap to memory
//---------- Paste radar picture form memory to radar-frame -------
dc.BitBlt(0,0,rect.right, rect.bottom ,
		  &m_dcMem,0,0,SRCCOPY);

DeleteDC(m_dcMem);  
}

//################################################################
// DrawSliderThumb()
//#################################################################

void S_DrawSliderThumb(CWnd* pWnd ,CBitmap* SliderThumbBmap )
{   
CClientDC		dc( pWnd );		// dc is radar-frame in dialog box
CRect			rect;			// radar-frame size
CDC				m_dcMem;		// Compatible memory DC for Radar show   
CSliderCtrl*	pSlider;

pSlider=(CSliderCtrl*) pWnd;
pSlider->GetThumbRect(&rect);
//-- Get frame coordinate -- Zero based coordinate ----
VERIFY(m_dcMem.CreateCompatibleDC(&dc));				//---- Create memory DC using the LED-frame
m_dcMem.SelectObject(SliderThumbBmap);					//---- load LED-frame's bitmap to memory
//---------- Paste radar picture form memory to radar-frame -------
dc.BitBlt(rect.left ,rect.top,
		  rect.right,rect.bottom,
		  &m_dcMem,0,0,SRCCOPY);

DeleteDC(m_dcMem);
   
}
	
//##########################################################
//	S_NewSlider
//##########################################################
LRESULT CALLBACK S_NewSlider(HWND hwnd,UINT iMsg,
								 WPARAM	wParam,LPARAM lParam)
{
int	 ControlID=0;
UINT IDBuffer[4]={  IDC_SLIDER_PAN_SPEED, IDC_SLIDER_TILT_SPEED,
					IDC_SLIDER_ZOOM_SPEED,IDC_SLIDER_FOCUS_SPEED };


switch( GetDlgCtrlID(hwnd) )
	{
	case IDC_SLIDER_PAN_SPEED  :	ControlID=0;	break;
	case IDC_SLIDER_TILT_SPEED :	ControlID=1;	break;
	case IDC_SLIDER_ZOOM_SPEED :	ControlID=2;	break;
	case IDC_SLIDER_FOCUS_SPEED:	ControlID=3;	break;
	}

switch (iMsg)
	{
	case WM_PAINT		:
		CallWindowProc(OldSlider[ControlID],hwnd,iMsg,wParam,lParam);
		S_DrawSliderChannel(G_ControlDlg->GetDlgItem(IDBuffer[ControlID] ),
							&(G_ControlDlg->m_BmpSliderChannel) );
		S_DrawSliderThumb(G_ControlDlg->GetDlgItem(IDBuffer[ControlID] ),
							&(G_ControlDlg->m_BmpSliderThumb) );
		//return	CallWindowProc(OldSlider[ControlID],hwnd,iMsg,wParam,lParam);
		break;
	case WM_KILLFOCUS	:
		//CallWindowProc(OldSlider[ControlID],hwnd,iMsg,wParam,lParam);
		S_DrawSliderChannel(G_ControlDlg->GetDlgItem(IDBuffer[ControlID] ),
							&(G_ControlDlg->m_BmpSliderChannel) );
		S_DrawSliderThumb(G_ControlDlg->GetDlgItem( IDBuffer[ControlID] ),
							&(G_ControlDlg->m_BmpSliderThumb) );
		break;
	default :
		return	CallWindowProc(OldSlider[ControlID],hwnd,iMsg,wParam,lParam);
		break;
	}

}

